#include <U8g2lib.h>
#include <math.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

int secAngle = 0;  // angle for second hand

void setup() {
  u8g2.begin();
}

void loop() {

  int centerX = 64;
  int centerY = 32;
  int radius = 20;

  // second hand end point
  int x = centerX + radius * cos(secAngle * 0.10472);  // convert secAngle to radians
  int y = centerY + radius * sin(secAngle * 0.10472);

  secAngle++;
  if (secAngle >= 60) secAngle = 0;

  u8g2.firstPage();
  do {
    u8g2.drawCircle(centerX, centerY, radius);
    u8g2.drawLine(centerX, centerY, x, y);
  } while (u8g2.nextPage());

  delay(200);
}