#include <Wire.h>

#define MPU6050_ADDR 0x68
#define ACCEL_XOUT_H 0x3B

long accX_offset = 0, accY_offset = 0, accZ_offset = 0;

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // Wake up MPU6050
  Wire.beginTransmission(MPU6050_ADDR);
  Wire.write(0x6B);
  Wire.write(0);
  Wire.endTransmission();

  delay(1000);

  calibrateAccelerometer();
}

void loop() {
  // Nothing here - calibration prints automatically
}

void calibrateAccelerometer() {
  long sumX = 0, sumY = 0, sumZ = 0;

  Serial.println("Calibrating Accelerometer... Keep the sensor still.");

  for (int i = 0; i < 200; i++) {
    Wire.beginTransmission(MPU6050_ADDR);
    Wire.write(ACCEL_XOUT_H);
    Wire.endTransmission(false);
    Wire.requestFrom(MPU6050_ADDR, 6, true);

    int16_t rawX = (Wire.read() << 8) | Wire.read();
    int16_t rawY = (Wire.read() << 8) | Wire.read();
    int16_t rawZ = (Wire.read() << 8) | Wire.read();

    sumX += rawX;
    sumY += rawY;
    sumZ += rawZ;

    delay(5);
  }

  accX_offset = sumX / 200;
  accY_offset = sumY / 200;
  accZ_offset = (sumZ / 200) - 16384; // 1g correction (Z-axis)

  Serial.println("Accelerometer Calibration Done:");
  Serial.print("X Offset = "); Serial.println(accX_offset);
  Serial.print("Y Offset = "); Serial.println(accY_offset);
  Serial.print("Z Offset = "); Serial.println(accZ_offset);
}