#include <Wire.h>

#define MPU6050_ADDR 0x68
#define GYRO_XOUT_H 0x43

long gyroX_offset = 0, gyroY_offset = 0, gyroZ_offset = 0;

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // Wake up MPU6050
  Wire.beginTransmission(MPU6050_ADDR);
  Wire.write(0x6B);
  Wire.write(0);
  Wire.endTransmission();

  delay(1000);

  calibrateGyroscope();
}

void loop() {
  // Nothing here - calibration prints automatically
}

void calibrateGyroscope() {
  long sumX = 0, sumY = 0, sumZ = 0;

  Serial.println("Calibrating Gyroscope... Keep the sensor still.");

  for (int i = 0; i < 200; i++) {
    Wire.beginTransmission(MPU6050_ADDR);
    Wire.write(GYRO_XOUT_H);
    Wire.endTransmission(false);
    Wire.requestFrom(MPU6050_ADDR, 6, true);

    int16_t rawX = (Wire.read() << 8) | Wire.read();
    int16_t rawY = (Wire.read() << 8) | Wire.read();
    int16_t rawZ = (Wire.read() << 8) | Wire.read();

    sumX += rawX;
    sumY += rawY;
    sumZ += rawZ;

    delay(5);
  }

  gyroX_offset = sumX / 200;
  gyroY_offset = sumY / 200;
  gyroZ_offset = sumZ / 200;

  Serial.println("Gyroscope Calibration Done:");
  Serial.print("X Offset = "); Serial.println(gyroX_offset);
  Serial.print("Y Offset = "); Serial.println(gyroY_offset);
  Serial.print("Z Offset = "); Serial.println(gyroZ_offset);
}