// fonts.h — Custom 7-segment font map for MAX7219
#ifndef FONTS_H
#define FONTS_H

// Segment bit positions for reference:
//  -- a --
// |       |
// f       b
// |       |
//  -- g --
// |       |
// e       c
// |       |
//  -- d --   (dp is bit 7)
//
// Bit order (MSB to LSB): dp g f e d c b a

const byte FONT_7SEG[128] = {
  // ASCII 0–31: non-printable -> blank
  0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,
  0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,
  0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,
  0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,0b00000000,

  // Space to /
  0b00000000, // ' ' (space)
  0b10000110, // '!'
  0b00100010, // '"'
  0b01111110, // '#'
  0b01101101, // '$'
  0b11010010, // '%'
  0b01000110, // '&'
  0b00100000, // '''
  0b00111001, // '('
  0b00001111, // ')'
  0b01100011, // '*'
  0b01110011, // '+'
  0b00000100, // ','
  0b01000000, // '-'
  0b10000000, // '.'
  0b01010010, // '/'

  // 0–9
  0b00111111, // '0'
  0b00000110, // '1'
  0b01011011, // '2'
  0b01001111, // '3'
  0b01100110, // '4'
  0b01101101, // '5'
  0b01111101, // '6'
  0b00000111, // '7'
  0b01111111, // '8'
  0b01101111, // '9'

  // : to @
  0b00001001, // ':'
  0b00001101, // ';'
  0b01100001, // '<'
  0b01001000, // '='
  0b01000011, // '>'
  0b11010011, // '?'
  0b01011111, // '@'

  // A–Z (you can customize as you wish)
  0b01110111, // 'A'
  0b01111100, // 'B'
  0b00111001, // 'C'
  0b01011110, // 'D'
  0b01111001, // 'E'
  0b01110001, // 'F'
  0b00111101, // 'G'
  0b01110110, // 'H'
  0b00000110, // 'I'
  0b00011110, // 'J'
  0b01110101, // 'K'
  0b00111000, // 'L'
  0b00010101, // 'M'
  0b00110111, // 'N'
  0b00111111, // 'O'
  0b01110011, // 'P'
  0b01100111, // 'Q'
  0b00110001, // 'R'
  0b01101101, // 'S'
  0b01111000, // 'T'
  0b00111110, // 'U'
  0b00111110, // 'V'
  0b00101010, // 'W'
  0b01110110, // 'X'
  0b01101110, // 'Y'
  0b01011011, // 'Z'

  // [ to `
  0b00111001, // '['
  0b01100100, // '\'
  0b00001111, // ']'
  0b01100010, // '^'
  0b00001000, // '_'
  0b00000010, // '`'

  // a–z (custom lowercase approximations)
  0b01011111, // 'a'
  0b01111100, // 'b'
  0b01011000, // 'c'
  0b01011110, // 'd'
  0b01111011, // 'e'
  0b01110001, // 'f'
  0b01101111, // 'g'
  0b01110100, // 'h'
  0b00000100, // 'i'
  0b00001100, // 'j'
  0b01110101, // 'k'
  0b00110000, // 'l'
  0b00010100, // 'm'
  0b01010100, // 'n'
  0b01011100, // 'o'
  0b01110011, // 'p'
  0b01100111, // 'q'
  0b01010000, // 'r'
  0b01101101, // 's'
  0b01111000, // 't'
  0b00011100, // 'u'
  0b00011100, // 'v'
  0b00101010, // 'w'
  0b01110110, // 'x'
  0b01101110, // 'y'
  0b01011011, // 'z'

  // { | } ~ DEL
  0b00001001, // '{'
  0b00000110, // '|'
  0b00001100, // '}'
  0b01000010, // '~'
  0b00000000  // DEL
};

#endif
