#include <LedControl.h>
#include "fonts.h"

// Pin connections
const int DIN_PIN = 11;   // Data (MOSI)
const int CLK_PIN = 13;   // Clock (SCK)
const int CS_PIN  = 10;   // Chip Select (LOAD)
const int NUM_MODULES = 1; // One module = 8 digits

#define ENABLE_SEGMENT_REMAP   1   // Set to 1 if characters look mirrored
#define REVERSE_DIGIT_ORDER    0   // Set to 1 if digits appear reversed

LedControl lc = LedControl(DIN_PIN, CLK_PIN, CS_PIN, NUM_MODULES);

String message = " HELLO 12345678  ";   // Message to scroll
int scrollDelay = 300;               // Delay between shifts (ms)

//------------------------------------------------------------------
// Setup
//------------------------------------------------------------------
void setup() {
  lc.shutdown(0, false);   // Wake up display
  lc.setIntensity(0, 8);   // Brightness (0–15)
  lc.clearDisplay(0);      // Clear all digits
}

//------------------------------------------------------------------
// Main loop
//------------------------------------------------------------------
void loop() {
  scrollText(message);
}

//------------------------------------------------------------------
// Reverse the lower 7 bits if needed (fix mirrored characters)
//------------------------------------------------------------------
uint8_t remap7seg(uint8_t v) {
  uint8_t dp = v & 0x80;        // Keep decimal point (bit 7)
  uint8_t low7 = v & 0x7F;      // Extract lower 7 bits (A–G)
  uint8_t rev = 0;
  for (uint8_t i = 0; i < 7; ++i)
    if (low7 & (1 << i)) rev |= (1 << (6 - i));
  return dp | rev;
}

//------------------------------------------------------------------
// Scroll a message across the 7-segment display
//------------------------------------------------------------------
void scrollText(String text) {
  text += "        ";  // Add spaces at the end for smooth exit
  int len = text.length();

  for (int pos = 0; pos < len - 7; pos++) {
    for (int i = 0; i < 8; i++) {
      char c = text.charAt(pos + i);
      byte pattern = FONT_7SEG[(int)c];

#if ENABLE_SEGMENT_REMAP
      pattern = remap7seg(pattern);
#endif

#if REVERSE_DIGIT_ORDER
      int displayPos = i;
#else
      int displayPos = 7 - i;
#endif

      lc.setRow(0, displayPos, pattern);
    }
    delay(scrollDelay);
  }
}
