#include <Wire.h>
#include <LiquidCrystal_I2C.h>

LiquidCrystal_I2C lcd(0x27, 16, 2); // I2C address 0x27, 16x2 LCD

int irPin = 2; // Digital pin connected to IR sensor

void setup() {
  pinMode(irPin, INPUT);
  lcd.init();
  lcd.backlight();
}

void loop() {
  int sensorState = digitalRead(irPin);

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("IR Digital State:");

  lcd.setCursor(0, 1);
  if(sensorState == LOW) {
    lcd.print("Object Detected");
  } else {
    lcd.print("No Object      ");
  }

  delay(500);
}