const int trigPin = 9;
const int echoPin = 10;

void setup() {
  Serial.begin(9600);
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
}

float readDistance() {

  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);

  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  unsigned long duration = pulseIn(echoPin, HIGH, 38000); 
  // 38ms timeout = ~400cm

  if (duration == 0) {
    Serial.println("Error: No echo received (Object too far or sensor misaligned)");
    return -1; 
  }

  float distance = duration * 0.0343 / 2;

  if (distance < 2) {
    Serial.println("Error: Object too close (<2cm)");
    return -1;
  }

  if (distance > 400) {
    Serial.println("Error: Out of range (>400cm)");
    return -1;
  }

  return distance;
}

void loop() {
  float d = readDistance();

  if (d != -1) {
    Serial.print("Distance: ");
    Serial.print(d);
    Serial.println(" cm");
  }

  delay(200);
}