#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50  // AT25C256 base address

void setup() {
  Wire.begin(); 
  Serial.begin(9600);
  Serial.println("Writing single byte to AT25C256...");
  
  writeEEPROM(0x000A, 0x55); // Write 0x55 at memory address 0x000A
  delay(10); // Small delay for write cycle
  Serial.println("Write complete.");
}

void loop() {}

void writeEEPROM(unsigned int memAddress, byte data) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);  // High byte of address
  Wire.write(memAddress & 0xFF);         // Low byte of address
  Wire.write(data);                      // Data byte
  Wire.endTransmission();
  delay(5); // Allow EEPROM to complete the write cycle
}
