#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50

void setup() {
  Wire.begin();
  Serial.begin(9600);

  byte writeData[] = {10, 20, 30, 40, 50};
  writeMultiple(0x0010, writeData, 5);
  delay(10);

  byte readData[5];
  readMultiple(0x0010, readData, 5);

  Serial.println("Data read from EEPROM:");
  for (int i = 0; i < 5; i++) {
    Serial.print(readData[i]);
    Serial.print(" ");
  }
  Serial.println();
}

void loop() {}

void writeMultiple(unsigned int memAddress, byte *data, int length) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  for (int i = 0; i < length; i++) {
    Wire.write(data[i]);
  }
  Wire.endTransmission();
  delay(5);
}

void readMultiple(unsigned int memAddress, byte *buffer, int length) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, length);
  for (int i = 0; i < length && Wire.available(); i++) {
    buffer[i] = Wire.read();
  }
}
