#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50

void setup() {
  Wire.begin();
  Serial.begin(9600);

  int number = 12345;
  writeInt(0x0020, number);
  delay(10);

  int readNumber = readInt(0x0020);
  Serial.print("Stored Integer: ");
  Serial.println(readNumber);
}

void loop() {}

void writeInt(unsigned int memAddress, int value) {
  byte highByte = (value >> 8) & 0xFF;
  byte lowByte = value & 0xFF;

  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.write(highByte);
  Wire.write(lowByte);
  Wire.endTransmission();
  delay(5);
}

int readInt(unsigned int memAddress) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, 2);
  byte highByte = Wire.read();
  byte lowByte = Wire.read();

  return (highByte << 8) | lowByte;
}