#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50

void setup() {
  Wire.begin();
  Serial.begin(9600);

  float temperature = 36.78;
  writeFloat(0x0030, temperature);
  delay(10);

  float readTemp = readFloat(0x0030);
  Serial.print("Stored Float: ");
  Serial.println(readTemp, 2);
}

void loop() {}

void writeFloat(unsigned int memAddress, float value) {
  byte *data = (byte*)&value;
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  for (int i = 0; i < 4; i++) Wire.write(data[i]);
  Wire.endTransmission();
  delay(5);
}

float readFloat(unsigned int memAddress) {
  float value;
  byte *data = (byte*)&value;
  
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, 4);
  for (int i = 0; i < 4; i++) data[i] = Wire.read();
  
  return value;
}
