#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50   // Default I2C address (A0, A1, A2 = GND)

// Function to write a 32-bit hexadecimal value
void writeHex32(unsigned int memAddress, unsigned long hexValue) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);   // High byte of memory address
  Wire.write(memAddress & 0xFF);          // Low byte of memory address
  Wire.write((hexValue >> 24) & 0xFF);    // Byte 3 (MSB)
  Wire.write((hexValue >> 16) & 0xFF);    // Byte 2
  Wire.write((hexValue >> 8) & 0xFF);     // Byte 1
  Wire.write(hexValue & 0xFF);            // Byte 0 (LSB)
  Wire.endTransmission();
  delay(5);  // Allow EEPROM write cycle to complete
}

// Function to read a 32-bit hexadecimal value
unsigned long readHex32(unsigned int memAddress) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);   // High byte of memory address
  Wire.write(memAddress & 0xFF);          // Low byte of memory address
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, 4);  // Request 4 bytes
  unsigned long value = 0;
  for (int i = 0; i < 4; i++) {
    value = (value << 8) | Wire.read();     // Combine bytes into 32-bit value
  }
  return value;
}

void setup() {
  Wire.begin();            // Initialize I2C communication
  Serial.begin(9600);      // Start Serial Monitor
  delay(500);

  unsigned int writeAddress = 0x0020;     // Memory address to write
  unsigned long hexValue = 0x12ABCDEF;    // 32-bit hexadecimal value

  Serial.print("Writing value 0x");
  Serial.print(hexValue, HEX);
  Serial.print(" at address 0x");
  Serial.println(writeAddress, HEX);

  // Write the 32-bit HEX value
  writeHex32(writeAddress, hexValue);
  delay(10);

  // Read it back
  unsigned long readValue = readHex32(writeAddress);

  Serial.print("Read value: 0x");
  Serial.println(readValue, HEX);
}

void loop() {
  // No repeated action required
}
