#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50   // Default I2C address when A0, A1, A2 = GND

// Function to write a 16-bit hexadecimal value
void writeHex16(unsigned int memAddress, unsigned int hexValue) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);  // High byte of memory address
  Wire.write(memAddress & 0xFF);         // Low byte of memory address
  Wire.write((hexValue >> 8) & 0xFF);    // High byte of hex value
  Wire.write(hexValue & 0xFF);           // Low byte of hex value
  Wire.endTransmission();
  delay(5); // Wait for EEPROM to complete the write cycle
}

// Function to read a 16-bit hexadecimal value
unsigned int readHex16(unsigned int memAddress) {
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, 2);
  byte high = 0, low = 0;
  if (Wire.available()) high = Wire.read();
  if (Wire.available()) low = Wire.read();

  return (high << 8) | low;
}

void setup() {
  Wire.begin();            // Initialize I2C
  Serial.begin(9600);      // Start serial monitor
  delay(500);

  unsigned int writeAddress = 0x0010;  // Memory location to write
  unsigned int hexValue = 0x1A2B;      // 16-bit hex value to store

  Serial.print("Writing value 0x");
  Serial.print(hexValue, HEX);
  Serial.print(" at address 0x");
  Serial.println(writeAddress, HEX);

  // Write 16-bit HEX value to EEPROM
  writeHex16(writeAddress, hexValue);
  delay(10);

  // Read it back
  unsigned int readValue = readHex16(writeAddress);

  Serial.print("Read value: 0x");
  Serial.println(readValue, HEX);
}

void loop() {
  // Nothing to do repeatedly
}
