#include <Wire.h>

#define EEPROM_I2C_ADDRESS 0x50

void setup() {
  Wire.begin();
  Serial.begin(9600);
  
  byte data = readEEPROM(0x000A); // Read the byte from address 0x000A
  Serial.print("Data read from EEPROM: 0x");
  Serial.println(data, HEX);
}

void loop() {}

byte readEEPROM(unsigned int memAddress) {
  byte data = 0;
  Wire.beginTransmission(EEPROM_I2C_ADDRESS);
  Wire.write((memAddress >> 8) & 0xFF);
  Wire.write(memAddress & 0xFF);
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_I2C_ADDRESS, 1);
  if (Wire.available()) data = Wire.read();
  return data;
}
