#include <Wire.h>
#include <RTClib.h>
#include <LiquidCrystal_I2C.h>

RTC_DS3231 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

// ---------------------- TIME SETTINGS ----------------------
#define AUTO_TIME_SET     1
#define MANUAL_TIME_SET   0

int manualYear   = 2025;
int manualMonth  = 1;
int manualDate   = 15;
int manualHour   = 11;
int manualMinute = 10;
int manualSecond = 0;
// ------------------------------------------------------------

void setup() {
  Wire.begin();
  lcd.init();
  lcd.backlight();

  lcd.print("Initializing RTC");
  delay(1500);
  lcd.clear();

  if (!rtc.begin()) {
    lcd.print("RTC ERROR");
    while (1);
  }

#if AUTO_TIME_SET
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
#endif

#if MANUAL_TIME_SET
  rtc.adjust(DateTime(manualYear, manualMonth, manualDate,
                      manualHour, manualMinute, manualSecond));
#endif

  // Disable alarms
  rtc.clearAlarm(1);
  rtc.clearAlarm(2);

  // ------------------ ENABLE SQUARE WAVE OUTPUT ------------------
  rtc.writeSqwPinMode(DS3231_SquareWave1Hz);  
  // Options:
  // DS3231_SquareWave1Hz
  // DS3231_SquareWave1kHz
  // DS3231_SquareWave4kHz
  // DS3231_SquareWave8kHz
  // ---------------------------------------------------------------

  lcd.clear();
}

void loop() {

  DateTime now = rtc.now();

  // Display current time
  lcd.setCursor(0, 0);
  if (now.hour() < 10) lcd.print("0");
  lcd.print(now.hour()); lcd.print(":");

  if (now.minute() < 10) lcd.print("0");
  lcd.print(now.minute()); lcd.print(":");

  if (now.second() < 10) lcd.print("0");
  lcd.print(now.second());

  lcd.setCursor(0, 1);
  lcd.print("SQW: 1 KHz Output");

  delay(500);
}
