#include <Wire.h>
#include <RTClib.h>
#include <LiquidCrystal_I2C.h>

RTC_DS3231 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

// -------------------- SETTINGS --------------------
// Enable only ONE of the following:
#define AUTO_TIME_SET     1   // Set RTC from system compile time
#define MANUAL_TIME_SET   0   // Set RTC to manually defined values

// Manual time setup (works only when MANUAL_TIME_SET = 1)
int manualYear   = 2025;
int manualMonth  = 1;
int manualDate   = 15;
int manualHour   = 10;
int manualMinute = 45;
int manualSecond = 0;
// ---------------------------------------------------

void setup() {
  Wire.begin();
  lcd.init();
  lcd.backlight();

  if (!rtc.begin()) {
    lcd.print("RTC ERROR!");
    while (1);
  }

#if AUTO_TIME_SET
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
#endif

#if MANUAL_TIME_SET
  rtc.adjust(DateTime(manualYear, manualMonth, manualDate,
                      manualHour, manualMinute, manualSecond));
#endif

  // Clear any previous alarms
  rtc.clearAlarm(1);
  rtc.clearAlarm(2);

  // Disable any existing alarms
  rtc.disableAlarm(1);
  rtc.disableAlarm(2);

  // Enable SQW/INT output for alarms
  rtc.writeSqwPinMode(DS3231_OFF); // Ensures SQW works in alarm mode

  // Set Alarm 1 to trigger at 12:30:00
  rtc.setAlarm1(
           DateTime(2025, 11, 24, 13, 45, 0),
            DS3231_A1_Second | DS3231_A1_Minute | DS3231_A1_Hour
    );

  lcd.setCursor(0, 0);
  DateTime alarm1 = rtc.getAlarm1();
  lcd.print("Alarm Set ");
  lcd.print(alarm1.hour());
  lcd.print(":");
  lcd.print(alarm1.minute());
}

void loop() {
  DateTime now = rtc.now();

  lcd.setCursor(0, 1);
  lcd.print(now.hour());
  lcd.print(":");
  lcd.print(now.minute());
  lcd.print(":");
  lcd.print(now.second());

  // CHECK ALARM TRIGGER
  if (rtc.alarmFired(1)) {
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("ALARM TRIGGER!");

    // Clear alarm flag
    rtc.clearAlarm(1);

    delay(2000);
  }

  delay(500);
}