#include <Wire.h>
#include <RTClib.h>
#include <LiquidCrystal_I2C.h>

RTC_DS1307 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

// -------------------- SETTINGS --------------------
#define AUTO_TIME_SET     1   // Set RTC from system compile time
#define MANUAL_TIME_SET   0   // Set RTC to manually defined values

// Manual time setup (only used when MANUAL_TIME_SET = 1)
int manualYear   = 2025;
int manualMonth  = 1;
int manualDate   = 15;
int manualHour   = 10;
int manualMinute = 45;
int manualSecond = 0;
// ---------------------------------------------------

void setup() {
  Wire.begin();
  lcd.init();
  lcd.backlight();

  if (!rtc.begin()) {
    lcd.print("RTC ERROR");
    while (1);
  }

  // ---------------- TIME SETTING -------------------
#if AUTO_TIME_SET
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
#endif

#if MANUAL_TIME_SET
  rtc.adjust(DateTime(manualYear, manualMonth, manualDate,
                      manualHour, manualMinute, manualSecond));
#endif
  // ---------------------------------------------------

  // Choose one line based on required SQW frequency:
  rtc.writeSqwPinMode(DS1307_SquareWave1HZ);
  // rtc.writeSqwPinMode(DS1307_SquareWave4kHz);
  // rtc.writeSqwPinMode(DS1307_SquareWave8kHz);
  // rtc.writeSqwPinMode(DS1307_SquareWave32kHz);

  lcd.setCursor(0, 0);
  lcd.print("SQW Enabled");

  lcd.setCursor(0, 1);
  lcd.print("Freq: 1 Hz");  // Update text if you change the mode
}

void loop() {
  // Nothing required in loop – SQW output works automatically
}