#include <Wire.h>
#include <RTClib.h>
#include <LiquidCrystal_I2C.h>

RTC_DS1307 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

// -------------------- SETTINGS --------------------
#define AUTO_TIME_SET     1   // Auto set RTC from compile time
#define MANUAL_TIME_SET   0   // Manually set RTC time

// Manual time values
int manualYear   = 2025;
int manualMonth  = 1;
int manualDate   = 15;
int manualHour   = 10;
int manualMinute = 45;
int manualSecond = 0;
// ---------------------------------------------------

void setup() {
  Wire.begin();
  lcd.init();
  lcd.backlight();

  if (!rtc.begin()) {
    lcd.print("RTC ERROR");
    while (1);
  }

  // ---------------- TIME SETTING -------------------
#if AUTO_TIME_SET
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
#endif

#if MANUAL_TIME_SET
  rtc.adjust(DateTime(manualYear, manualMonth, manualDate,
                      manualHour, manualMinute, manualSecond));
#endif
  // ---------------------------------------------------

  // Example: Write data to DS1307 RAM
  rtc.writenvram(0, 123);   // Store value 123 at RAM address 0
  rtc.writenvram(1, 45);    // Store value 45 at RAM address 1

  // Read back values
  uint8_t value1 = rtc.readnvram(0);
  uint8_t value2 = rtc.readnvram(1);

  lcd.setCursor(0, 0);
  lcd.print("RAM0:");
  lcd.print(value1);

  lcd.setCursor(0, 1);
  lcd.print("RAM1:");
  lcd.print(value2);
}

void loop() {
  // Nothing to do — values already printed
}