#include <Wire.h>
#include "RTClib.h"
#include <LiquidCrystal_I2C.h>

RTC_DS1307 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

// -------------------- SETTINGS --------------------
// Enable only ONE of the following:
#define AUTO_TIME_SET     1   // Set RTC from system compile time
#define MANUAL_TIME_SET   0   // Set RTC to manually defined values

// Manual time setup (works only when MANUAL_TIME_SET = 1)
int manualYear   = 2025;
int manualMonth  = 1;
int manualDate   = 15;
int manualHour   = 10;
int manualMinute = 45;
int manualSecond = 0;
// ---------------------------------------------------

void setup() {
  Serial.begin(9600);
  Wire.begin();

  if (!rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

#if AUTO_TIME_SET
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
#endif

#if MANUAL_TIME_SET
  rtc.adjust(DateTime(manualYear, manualMonth, manualDate,
                      manualHour, manualMinute, manualSecond));
#endif

  lcd.begin(16, 2);
  lcd.backlight();
}

void loop() {
  DateTime now = rtc.now();

  // Format Date: DD/MM/YYYY
  char dateBuffer[17];
  snprintf(dateBuffer, sizeof(dateBuffer), "%02d/%02d/%04d",
           now.day(), now.month(), now.year());

  // Format Time: HH:MM:SS
  char timeBuffer[17];
  snprintf(timeBuffer, sizeof(timeBuffer), "%02d:%02d:%02d",
           now.hour(), now.minute(), now.second());

  // Display on LCD
  lcd.setCursor(0, 0);
  lcd.print(dateBuffer);

  lcd.setCursor(0, 1);
  lcd.print(timeBuffer);

  delay(1000);
}