#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include "DHT.h"

#define DHTPIN 2        // Data pin connected to DHT22
#define DHTTYPE DHT22   // Define sensor type as DHT22

DHT dht(DHTPIN, DHTTYPE);
LiquidCrystal_I2C lcd(0x27, 16, 2); // LCD address 0x27, 16x2 display

void setup() {
  lcd.init();             // Initialize the LCD
  lcd.backlight();        // Turn on LCD backlight
  dht.begin();            // Start DHT sensor
  lcd.setCursor(0, 0);
  lcd.print("DHT22 Sensor");
  delay(2000);
}

void loop() {
  float humidity = dht.readHumidity();
  float temperature = dht.readTemperature();

  if (isnan(humidity) || isnan(temperature)) {
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Sensor Error!");
    delay(2000);
    return;
  }

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Temp: ");
  lcd.print(temperature);
  lcd.print(" C");

  lcd.setCursor(0, 1);
  lcd.print("Hum: ");
  lcd.print(humidity);
  lcd.print(" %");

  delay(2000); // Update every 2 seconds
}
