#include "DHT.h"

#define DHTPIN 2         // Pin connected to the DHT sensor
#define DHTTYPE DHT22    // Change to DHT22 if using that sensor

DHT dht(DHTPIN, DHTTYPE);

void setup() {
  Serial.begin(9600);
  dht.begin();
  Serial.println("DHT Sensor Reading Started...");
}

void loop() {
  delay(2000);  // Wait a few seconds between measurements

  float humidity = dht.readHumidity();
  float temperature = dht.readTemperature(); // Default is Celsius

  if (isnan(humidity) || isnan(temperature)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  Serial.print("Humidity: ");
  Serial.print(humidity);
  Serial.print(" %\t");

  Serial.print("Temperature: ");
  Serial.print(temperature);
  Serial.println(" °C");
}
