#include <Wire.h>

#define ADXL345_ADDR 0x53

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // --- Put ADXL345 into Measurement Mode ---
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x2D);     // POWER_CTL register
  Wire.write(0x08);     // Measurement mode ON
  Wire.endTransmission();

  // --- Set Full Resolution Mode (10-bit to 13-bit depending on g-range) ---
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x31);     // DATA_FORMAT register
  Wire.write(0x08);     // Full Resolution + ±2g range
  Wire.endTransmission();

  // --- Set Data Rate to 100 Hz ---
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x2C);     // BW_RATE register
  Wire.write(0x0A);     // 100 Hz output data rate
  Wire.endTransmission();

  Serial.println("ADXL345 Initialized...");
}

void loop() {
  int16_t xRaw, yRaw, zRaw;

  // Select starting register
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x32);  
  Wire.endTransmission(false);

  // Read 6 bytes for X, Y, Z
  Wire.requestFrom(ADXL345_ADDR, 6, true);

  xRaw = (Wire.read() | (Wire.read() << 8));
  yRaw = (Wire.read() | (Wire.read() << 8));
  zRaw = (Wire.read() | (Wire.read() << 8));

  Serial.print("X Raw: "); Serial.print(xRaw);
  Serial.print("  | Y Raw: "); Serial.print(yRaw);
  Serial.print("  | Z Raw: "); Serial.println(zRaw);

  delay(300);
}