#include <Wire.h>

#define ADXL345_ADDR 0x53

float scaleFactor = 256.0; // For ±2g full-resolution mode

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // Measurement Mode
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x2D);
  Wire.write(0x08);
  Wire.endTransmission();

  // Full resolution mode ±2g
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x31);
  Wire.write(0x08);
  Wire.endTransmission();

  // Data rate 100 Hz
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x2C);
  Wire.write(0x0A);
  Wire.endTransmission();

  Serial.println("ADXL345 Ready...");
}

void loop() {
  int16_t xRaw, yRaw, zRaw;

  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x32);
  Wire.endTransmission(false);

  Wire.requestFrom(ADXL345_ADDR, 6, true);

  xRaw = (Wire.read() | (Wire.read() << 8));
  yRaw = (Wire.read() | (Wire.read() << 8));
  zRaw = (Wire.read() | (Wire.read() << 8));

  // Convert to g
  float xg = xRaw / scaleFactor;
  float yg = yRaw / scaleFactor;
  float zg = zRaw / scaleFactor;

  Serial.print("X (g): "); Serial.print(xg);
  Serial.print("  | Y (g): "); Serial.print(yg);
  Serial.print("  | Z (g): "); Serial.println(zg);

  delay(300);
}