#include <Wire.h>

#define ADXL345_ADDR 0x53

int16_t xRaw, yRaw, zRaw;
long xSum = 0, ySum = 0, zSum = 0;
int samples = 200;

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // Measurement Mode
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x2D);
  Wire.write(0x08);
  Wire.endTransmission();

  // Full resolution mode ±2g
  Wire.beginTransmission(ADXL345_ADDR);
  Wire.write(0x31);
  Wire.write(0x08);
  Wire.endTransmission();

  delay(200);
  Serial.println("Starting Calibration...");
  
  // --- Take multiple readings ---
  for (int i = 0; i < samples; i++) {

    Wire.beginTransmission(ADXL345_ADDR);
    Wire.write(0x32);
    Wire.endTransmission(false);

    Wire.requestFrom(ADXL345_ADDR, 6, true);

    xRaw = (Wire.read() | (Wire.read() << 8));
    yRaw = (Wire.read() | (Wire.read() << 8));
    zRaw = (Wire.read() | (Wire.read() << 8));

    xSum += xRaw;
    ySum += yRaw;
    zSum += zRaw;

    delay(5);
  }

  // --- Average values ---
  float xOffset = xSum / samples;
  float yOffset = ySum / samples;
  float zOffset = (zSum / samples) - 256.0; // Z should read ~1g at rest

  Serial.println("Calibration Complete:");
  Serial.print("X Offset: "); Serial.println(xOffset);
  Serial.print("Y Offset: "); Serial.println(yOffset);
  Serial.print("Z Offset: "); Serial.println(zOffset);

  Serial.println("Use these offsets in your main code.");
}

void loop() {
  // Nothing here – calibration runs in setup()
}