#include <SPI.h>
#include <SD.h>

File myFile;

const int chipSelect = 10;  // CS pin for SD card module

void setup() {
  Serial.begin(9600);
  Serial.print("Initializing SD card...");

  if (!SD.begin(chipSelect)) {
    Serial.println("Initialization failed!");
    while (1);
  }
  Serial.println("Initialization done.");

  myFile = SD.open("data.txt");

  if (myFile) {
    Serial.println("Reading data.txt...");
    while (myFile.available()) {
      Serial.write(myFile.read());
    }
    myFile.close();
  } else {
    Serial.println("Error opening data.txt!");
  }
}

void loop() {
  // Nothing to do here
}