#include <SPI.h>
#include <SD.h>

File dataFile;
const int chipSelect = 10;  // CS pin for SD module

void setup() {
  Serial.begin(9600);
  Serial.println("Initializing SD card...");

  if (!SD.begin(chipSelect)) {
    Serial.println("SD card initialization failed!");
    while (1);
  }
  Serial.println("SD card ready.");

  // Try creating or opening the file
  dataFile = SD.open("log.csv", FILE_WRITE);

  if (dataFile) {
    // If the file is empty, write the header
    if (dataFile.size() == 0) {
      dataFile.println("Time(s),Temperature(C),Humidity(%)");
      Serial.println("Header written to log.csv");
    }
    dataFile.close();
  } else {
    Serial.println("Error opening log.csv!");
  }
}

void loop() {
  static unsigned long previousMillis = 0;
  unsigned long currentMillis = millis();

  // Log data every 3 seconds
  if (currentMillis - previousMillis >= 3000) {
    previousMillis = currentMillis;

    // Simulated sensor values (replace with real sensor reads)
    float temperature = random(20, 35);  // °C
    float humidity = random(40, 70);     // %

    // Create a timestamp
    float timeSec = currentMillis / 1000.0;

    // Open the file to append new data
    dataFile = SD.open("log.csv", FILE_WRITE);

    if (dataFile) {
      dataFile.print(timeSec);
      dataFile.print(",");
      dataFile.print(temperature);
      dataFile.print(",");
      dataFile.println(humidity);
      dataFile.close();

      Serial.print("Logged: ");
      Serial.print(timeSec);
      Serial.print("s | ");
      Serial.print(temperature);
      Serial.print("°C | ");
      Serial.print(humidity);
      Serial.println("%");
    } else {
      Serial.println("Error opening log.csv!");
    }
  }
}