#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

int counter = 0;

void setup() {
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(SSD1306_WHITE);

  // Print float
  float temperature = 25.6789;
  display.setCursor(10, 20);
  display.print("Temp: ");
  display.print(temperature, 2);  // prints 25.68
  display.display();
  delay(5000);

}

void loop() {
  // Print Number
  display.clearDisplay();
  display.setCursor(10, 20);
  display.print("Count: ");
  display.print(counter);
  display.display();
  counter++;
  delay(1000);
}
