#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

int x = 10, y = 10;
int xSpeed = 2, ySpeed = 2;

void setup() {
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
}

void loop() {
  display.clearDisplay();

  // Draw ball
  display.fillCircle(x, y, 3, SSD1306_WHITE);

  // Update position
  x += xSpeed;
  y += ySpeed;

  // Bounce from edges
  if (x <= 3 || x >= SCREEN_WIDTH - 3) xSpeed = -xSpeed;
  if (y <= 3 || y >= SCREEN_HEIGHT - 3) ySpeed = -ySpeed;

  display.display();
  delay(20);
}
