#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"

TaskHandle_t Task1Handle;
TaskHandle_t Task2Handle;

void Task1(void *pvParameters)
{
    while (1)
    {
        printf("Task1: Sending notification to Task2\n");
        xTaskNotifyGive(Task2Handle);
        vTaskDelay(pdMS_TO_TICKS(1000));
    }
}

void Task2(void *pvParameters)
{
    while (1)
    {
        ulTaskNotifyTake(pdTRUE, portMAX_DELAY);
        printf("Task2: Notification received!\n");
    }
}

void app_main(void)
{
	xTaskCreate(Task2, "Task2", 2048, NULL, 2, &Task2Handle);
    xTaskCreate(Task1, "Task1", 2048, NULL, 2, &Task1Handle);
}