#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/timers.h"
#include "driver/gpio.h"

#define LED_PIN 2  
bool ledLevel = false;


TaskHandle_t ledTaskHandle;
TimerHandle_t timerHandle;

void timerCallback(TimerHandle_t xTimer)
{
    // Notify the LED task
    xTaskNotifyGive(ledTaskHandle);
}

void ledTask(void *pvParameters)
{
    gpio_reset_pin(LED_PIN);
    gpio_set_direction(LED_PIN, GPIO_MODE_OUTPUT);

    while (1)
    {
        // Wait until timer notifies
        ulTaskNotifyTake(pdTRUE, portMAX_DELAY);

        // Toggle LED
        ledLevel = !ledLevel;
        gpio_set_level(LED_PIN, ledLevel);

        printf("LED toggled. State: %d\n", ledLevel);
    }
}

void app_main(void)
{
    printf("FreeRTOS Timer + Task Notification Example\n");

    // Create LED Task
    xTaskCreate(ledTask, "LED_Task", 2048, NULL, 2, &ledTaskHandle);

    // Create Timer (1 second period, auto-reload)
    timerHandle = xTimerCreate("LED_Timer", pdMS_TO_TICKS(1000), pdTRUE, NULL, timerCallback);

    if (timerHandle != NULL)
    {
        xTimerStart(timerHandle, 0);
        printf("Timer started successfully.\n");
    }
    else
    {
        printf("Timer creation failed!\n");
    }
}
