#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/timers.h"
#include "driver/gpio.h"

TimerHandle_t myTimer;
#define LED_PIN 2
bool ledLevel = false;

void myTimerCallback(TimerHandle_t xTimer)
{
    printf("Timer expired! Callback executed.\n");
	ledLevel = !ledLevel;
	gpio_set_level(LED_PIN, ledLevel);
}

void app_main(void)
{
	gpio_reset_pin(LED_PIN);
	gpio_set_direction(LED_PIN, GPIO_MODE_OUTPUT);

    myTimer = xTimerCreate("MyTimer", pdMS_TO_TICKS(1000), pdTRUE, 0, myTimerCallback);

    if (myTimer == NULL)
    {
        printf("Timer creation failed!\n");
    }
    else
    {
        printf("Starting timer...\n");
        xTimerStart(myTimer, 0);
    }
}