#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"

void systemClockConfig (void)
{
    SysCtlClockSet(SYSCTL_XTAL_16MHZ|SYSCTL_USE_OSC|SYSCTL_OSC_MAIN);  // Using MOSC 16MHz (External) Direct
}

void delay_ms(uint32_t ms)
{
    SysCtlDelay ((ms * SysCtlClockGet()) / 3000UL);
} 

int main(void)
{
    systemClockConfig();
    
    // Enable the GPIOF Clock and configure PG4 as output
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOF))
    {
    }
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_4);
    
    while(1)
    {   
        GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_4, GPIO_PIN_4);  // Set the PF4 High
        delay_ms(100);
        GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_4, 0);  // ReSet the PF4 Low
        delay_ms(100);
    }
}
