/*
 * sht21.h
 *
 *  Created on: Oct 13, 2025
 *      Author: controllerstech
 */

#ifndef INC_SHT21_H_
#define INC_SHT21_H_

#include "main.h"   // Change this include as per your MCU family
#include <stdio.h>

// Enable or disable debug logs globally
#define SHT21_DEBUG  0
#define SHT21_USER   1

// Redirect logs to UART/printf or your own logger
#if SHT21_DEBUG
    #define DEBUG_LOG(...)     printf("[DEBUG] " __VA_ARGS__)
#else
    #define DEBUG_LOG(...)
#endif

#if SHT21_USER
    #define USER_LOG(...)     printf("[USER] " __VA_ARGS__)
#else
    #define USER_LOG(...)
#endif

// SHT21 Constants and Commands
#define SHT21_I2C_ADDR             (0x80)
#define SHT21_TRIG_TEMP_HOLD       0xE3
#define SHT21_TRIG_HUM_HOLD       0xE5
#define SHT21_TRIG_TEMP_NOHOLD     0xF3
#define SHT21_TRIG_HUM_NOHOLD     0xF5
#define SHT21_WRITE_USER_REG       0xE6
#define SHT21_READ_USER_REG        0xE7
#define SHT21_SOFT_RESET           0xFE

// Data Structures
typedef enum {
    SHT21_OK = 0,
    SHT21_ERROR,
    SHT21_TIMEOUT,
    SHT21_CRC_ERROR
} SHT21_StatusTypeDef;

// Function Prototypes
SHT21_StatusTypeDef SHT21_Init(void);
SHT21_StatusTypeDef SHT21_SoftReset(void);

SHT21_StatusTypeDef SHT21_ReadUserRegister(uint8_t *value);
SHT21_StatusTypeDef SHT21_WriteUserRegister(uint8_t value);

SHT21_StatusTypeDef SHT21_ReadTemperature(float *temperature);
SHT21_StatusTypeDef SHT21_ReadHumidity(float *humidity);



#endif /* INC_SHT21_H_ */
