#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/semphr.h"
#include <stdio.h>

SemaphoreHandle_t sharedMutex;

void LowPriorityTask(void *pvParameters)
{
    while (1)
    {
        if (xSemaphoreTake(sharedMutex, portMAX_DELAY))
        {
            printf("LowPriorityTask: Holding shared resource  current priority: %u\n", uxTaskPriorityGet(NULL));
            vTaskDelay(pdMS_TO_TICKS(2000)); // Simulate long operation
            printf("LowPriorityTask: Releasing shared resource  current priority: %u\n", uxTaskPriorityGet(NULL));
            xSemaphoreGive(sharedMutex);
        }
        vTaskDelay(pdMS_TO_TICKS(500));
    }
}

void MediumPriorityTask(void *pvParameters)
{
    while (1)
    {
        printf("MediumPriorityTask: Doing background work\n");
        vTaskDelay(pdMS_TO_TICKS(500));
    }
}

void HighPriorityTask(void *pvParameters)
{
    while (1)
    {
        vTaskDelay(pdMS_TO_TICKS(1000)); // Let low task grab mutex first

        printf("HighPriorityTask: Needs shared resource\n");
        if (xSemaphoreTake(sharedMutex, portMAX_DELAY))
        {
            printf("HighPriorityTask: Got shared resource\n");
            vTaskDelay(pdMS_TO_TICKS(1000));
            printf("HighPriorityTask: Releasing shared resource\n");
            xSemaphoreGive(sharedMutex);
        }
    }
}

void app_main(void)
{
    sharedMutex = xSemaphoreCreateMutex();
    if (sharedMutex == NULL)
    {
        printf("Failed to create Mutex!\n");
        return;
    }

    // Priorities: High > Medium > Low
    xTaskCreate(LowPriorityTask, "LowPriority", 2048, NULL, 1, NULL);
    xTaskCreate(MediumPriorityTask, "MediumPriority", 2048, NULL, 2, NULL);
    xTaskCreate(HighPriorityTask, "HighPriority", 2048, NULL, 3, NULL);
}
