#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/semphr.h"
#include <stdio.h>

SemaphoreHandle_t dataReadySemaphore;
int sensorData = 0;

void ADCTask(void *pvParameters)
{
    while (1)
    {
        sensorData++;
        printf("ADC Task: New data = %d\n", sensorData);

        // Signal UART task that new data is ready
        xSemaphoreGive(dataReadySemaphore);

        vTaskDelay(pdMS_TO_TICKS(1000)); // Read every second
    }
}

void UARTTask(void *pvParameters)
{
    while (1)
    {
        // Wait until data is ready
        if (xSemaphoreTake(dataReadySemaphore, portMAX_DELAY))
        {
            printf("UART Task: Sending data = %d\n", sensorData);
        }
    }
}

void app_main(void)
{
    dataReadySemaphore = xSemaphoreCreateBinary();

    if (dataReadySemaphore == NULL)
    {
        printf("Failed to create semaphore!\n");
        return;
    }

    xTaskCreate(ADCTask, "ADC Task", 2048, NULL, 1, NULL);
    xTaskCreate(UARTTask, "UART Task", 2048, NULL, 1, NULL);
}