#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/queue.h"
#include <stdio.h>

QueueHandle_t testQueue;

void SenderTask(void *pvParameters)
{
    int SentValue = 0;
    while (1)
    {
        SentValue++;
        printf("Sender Task: Sending value %d\n", SentValue);
        xQueueSend(testQueue, &SentValue, portMAX_DELAY);
        vTaskDelay(pdMS_TO_TICKS(1000)); // Send every second
    }
}

void ReceiverTask(void *pvParameters)
{
    int receivedValue = 0;
    while (1)
    {
        if (xQueueReceive(testQueue, &receivedValue, portMAX_DELAY))
        {
            printf("Receiver Task: Received value %d\n", receivedValue);
        }
    }
}

void app_main(void)
{
    testQueue = xQueueCreate(5, sizeof(int));

    if (testQueue == NULL)
    {
        printf("Queue creation failed!\n");
        return;
    }

    xTaskCreate(SenderTask, "Sender Task", 2048, NULL, 1, NULL);
    xTaskCreate(ReceiverTask, "Receiver Task", 2048, NULL, 1, NULL);
}