#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include <stdio.h>

EventGroupHandle_t sensorEventGroup;

#define SENSOR1_BIT (1 << 0)
#define SENSOR2_BIT (1 << 1)

void Sensor1Task(void *pvParameters)
{
    while (1)
    {
        printf("Sensor1: Reading data...\n");
        vTaskDelay(pdMS_TO_TICKS(1000)); // Simulate sensor delay
        printf("Sensor1: Data ready\n");

        xEventGroupSetBits(sensorEventGroup, SENSOR1_BIT);
        vTaskDelay(pdMS_TO_TICKS(2000)); // Wait before next cycle
    }
}

void Sensor2Task(void *pvParameters)
{
    while (1)
    {
        printf("Sensor2: Reading data...\n");
        vTaskDelay(pdMS_TO_TICKS(1500)); // Simulate different timing
        printf("Sensor2: Data ready\n");

        xEventGroupSetBits(sensorEventGroup, SENSOR2_BIT);
        vTaskDelay(pdMS_TO_TICKS(2000));
    }
}

void ProcessingTask(void *pvParameters)
{
    while (1)
    {
        printf("Processing Task: Waiting for both sensors...\n");

        // Wait for both Sensor1 and Sensor2 to signal readiness
        xEventGroupWaitBits(sensorEventGroup,
                            SENSOR1_BIT | SENSOR2_BIT,
                            pdTRUE,   // Clear bits after waiting
                            pdTRUE,   // Wait for both bits
                            portMAX_DELAY);

        printf("Processing Task: Both sensors ready! Processing data...\n");
        vTaskDelay(pdMS_TO_TICKS(1000));
    }
}

void app_main(void)
{
    sensorEventGroup = xEventGroupCreate();

    if (sensorEventGroup == NULL)
    {
        printf("Failed to create Event Group!\n");
        return;
    }

    xTaskCreate(Sensor1Task, "Sensor1", 2048, NULL, 1, NULL);
    xTaskCreate(Sensor2Task, "Sensor2", 2048, NULL, 1, NULL);
    xTaskCreate(ProcessingTask, "Processing", 2048, NULL, 2, NULL);
}