// External interrupt LED toggle - safe ISR pattern

const int buttonPin = 2;   // INT0 on Uno/Nano
const int ledPin = 13;     // built-in LED pin (or any digital pin)

volatile bool irqFlag = false;   // set by ISR, read in loop
unsigned long lastToggle = 0;    // last toggle time for debounce
const unsigned long debounceMs = 50; // debounce window in milliseconds

/* Check the pins for Harwdware Interrupt */
//void setup() {
//  Serial.begin(9600);
//  delay(2000);  // Wait for Serial Monitor to open
//
//  Serial.println("Checking interrupt numbers:");
//  Serial.print("Pin 2: ");
//  Serial.println(digitalPinToInterrupt(2));  // Returns 0 for INT0 on Uno
//  Serial.print("Pin 3: ");
//  Serial.println(digitalPinToInterrupt(3));  // Returns 1 for INT1 on Uno
//  Serial.print("Pin 4: ");
//  Serial.println(digitalPinToInterrupt(4));  // Returns -1 (no interrupt)
//  Serial.print("Pin 5: ");
//  Serial.println(digitalPinToInterrupt(5));  // Returns -1 (no interrupt)
//}
//
//void loop() {
//}

void setup() {
  pinMode(ledPin, OUTPUT);
  pinMode(buttonPin, INPUT_PULLUP); // use internal pull-up

  // Attach interrupt on pin 2 (INT0). Trigger on FALLING (button press).
  attachInterrupt(digitalPinToInterrupt(buttonPin), handleButtonISR, FALLING);

  Serial.begin(9600);
  Serial.println("Interrupt LED toggle example started");
}

void loop() {
  // If ISR set the flag, handle it here safely.
  if (irqFlag) {
    irqFlag = false;               // clear the flag early

    unsigned long now = millis();
    // Simple debounce: ignore presses too close together
    if (now - lastToggle >= debounceMs) {
      // Toggle LED
      bool current = digitalRead(ledPin);
      digitalWrite(ledPin, !current);
      lastToggle = now;
    }
  }

  // Other non-blocking code can run here
}

// Interrupt Service Routine - keep it short and fast
void handleButtonISR() {
  irqFlag = true;  // mark that button was pressed
}
