#include <Wire.h>
#include <LiquidCrystal_I2C.h>

// I2C address and 16x2 LCD
LiquidCrystal_I2C lcd(0x27, 16, 2);

// Define 5 custom characters (5x8 pixels each)
byte char1[8] = {0x00,0x0A,0x0A,0x00,0x11,0x0E,0x00,0x00}; // Smiley
byte char2[8] = {0x04,0x0E,0x15,0x04,0x04,0x04,0x04,0x00}; // Arrow up
byte char3[8] = {0x04,0x04,0x04,0x04,0x15,0x0E,0x04,0x00}; // Arrow down
byte char4[8] = {0x00,0x0A,0x0A,0x0A,0x11,0x0E,0x00,0x00}; // Another smiley
byte char5[8] = {0x00,0x04,0x0E,0x1F,0x0E,0x04,0x00,0x00}; // Heart

void setup() {
  lcd.init();
  lcd.backlight();

  // Create custom characters at positions 0-4
  lcd.createChar(0, char1);
  lcd.createChar(1, char2);
  lcd.createChar(2, char3);
  lcd.createChar(3, char4);
  lcd.createChar(4, char5);

  lcd.setCursor(0, 0);
  lcd.print("Have a nice day ");
  // Display custom characters
  lcd.setCursor(6,1);
  lcd.write(byte(0));
  lcd.write(byte(1));
  lcd.write(byte(2));
  lcd.write(byte(3));
  lcd.write(byte(4));
}

void loop() {
  // Nothing here; characters are static
}
