

#include <LPC214X.h>
#include "PLL.h"
#include <stdint.h>


/* Timer initialisation function
   select the timer mode
	 Enter the value for the Prescalar counter
	 reset the timer
*/
void Timer_Init (uint32_t Tim_clock)
{
	T0CTCR = 0x00;  // select the timer mode
	T0PR = ((60000000/Tim_clock)-1);
	T0TCR = (1<<1);  // Reset the timer
}


// function for delay
/*  Steps to obtain the delay
    set TC counter to 0
    reset timer
    enable timer 
    wait untill TC counter reaches our defined value
    disable timer
*/
void delay (uint32_t time)
{
	T0TC = 0;
	T0TCR = (1<<1);  // Reset the timer
	T0TCR = (1<<0);  // enable the timer
	while (T0TC < time);  //wait untill TC counter reaches our defined value
	T0TCR = 0;
}


int main ()
{
	PINSEL0 = 0;  //Normal GPIO operations from P0.0 to P0.15
	PINSEL1 = 0;  //Normal GPIO operations from P0.16 to P0.31
	
	// My LED is connected to P0.21
	
	// Set P0.21 as output
	IODIR0 |= (1<<21);
	
	// initialise the PLL
	PLL_Init ();
	
	VPBDIV=0x01;  // system clock = PLL = 60 MHz
	
//	Timer_Init (1000);  // timer clock is 1KHz  --> 1ms 
	
	Timer_Init (1000000);  // Timer clock is 1MHz  --> 1us
	
	while (1)
	{
		IOSET0 |= (1<<21);   // Set the LED
//		delay (1000);  // wait for 1000ms
		delay (1000000);  // wait for 1000000 us
		IOCLR0 |= (1<<21); // Clear the LED
//		delay (1000);  // wait for 1000ms
		delay (1000000);  // wait for 1000000 us
	}
}

