

/* PLL for CClk of 60Mhz and Pclk will be decided in main program.
VPBDIV=0x00	APB bus clock (PCLK) is one fourth of the processor clock (CCLK)
VPBDIV=0x01	APB bus clock (PCLK) is the same as the processor clock (CCLK)
VPBDIV=0x02	APB bus clock (PCLK) is one half of the processor clock (CCLK)
VPBDIV=0x03	Reserved. If this value is written to the APBDIV register, it has no effect (the previous setting is retained).*/


#include <lpc214x.h>
void PLL_Init(void)
{
 PLL0CON =  0x01;    //Enable PLL by setting bit PLLE = 1
/*
	CCLK = M x FOSC	
	CCLK = FCCO / (2 x P), FCCO is in the range of 156 MHz to 320 MHz
	
	I need 60Mhz (max) and I have 12Mhz (cystal)  M = CCLK / Fosc = 60MHz / 12MHz = 5. 
	Consequently, M - 1 = 4 will be written as PLLCFG [4:0]
	
	Value for P can be derived from P = FCCO/ (CCLK x 2), using condition that FCCO must be
  in range of 156 MHz to 320 MHz. Assuming the lowest allowed frequency for
  FCCO = 156 MHz, P = 156 MHz / (2 x 60 MHz) = 1.3. The highest FCCO frequency criteria
  produces P = 2.67. The only solution for P that satisfies both of these requirements and is P = 2. 
	Therefore, PLLCFG[6:5] = 2 will be used.
	
	so we have PLLCFG: 10 1000
*/
 PLL0CFG =  0x24;    //Multiplier and divider setup. P =2 and M-1= 4.
 PLL0FEED = 0xAA;   //Feed sequence
 PLL0FEED = 0x55;   // feed sequence
 
 while(!(PLL0STAT & 0x00000400)); //is locked? check the PLOCK bit 
 
 PLL0CON = 0x03;   //Connect PLL after PLL is locked by setting PLLE=1, PLLC=1
 PLL0FEED = 0xAA;  //Feed sequence
 PLL0FEED = 0x55;  //Feed sequence
}
